jQuery(function($){
	
	$("#fechaInscDesde").rup_date();
	$("#fechaInscHasta").rup_date();
	
	jQuery.validator.addMethod("validacionFechas", function(value, element, params) {
		var fechaDesde=$("#fechaInscDesde").val();
		var fechaHasta=$("#fechaInscHasta").val();
		if(fechaDesde!=''&&fechaHasta!=''){
			fechaDesde=new Date(fechaDesde.substring(6,10),fechaDesde.substring(3,5),fechaDesde.substring(0,2));
			fechaHasta=new Date(fechaHasta.substring(6,10),fechaHasta.substring(3,5),fechaHasta.substring(0,2));
			if(fechaDesde>fechaHasta){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
		
	});	
	
	$("#empresa").rup_table({
		url: "../ab03b47v00",
		colNames: [
			"id047",
			$.rup.i18n.app.expedientes.numRera,
			$.rup.i18n.app.empresas.fechaInscripcion,
			$.rup.i18n.app.expedientes.cifNif,
			$.rup.i18n.app.empresas.empresa,
			$.rup.i18n.app.empresas.direccion,
			$.rup.i18n.app.empresas.telefono
		],
		colModel: [
			{ 	name: "id047", 
			 	label: "id047",
				align: "", 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "numRera047", 
			 	label: "numRera047",
				align: "center", 
				width: 80, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "fechaInscripcion", 
			 	label: "fechaInscripcion",
				align: "center", 
				width: 100, 
				ruptype: "datepicker", 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "nifEmpresa047", 
			 	label: "nifEmpresa047",
				align: "center", 
				width: 80, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "razonSocial047", 
			 	label: "razonSocial047",
				align: "left", 
				width: 200, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "direccionemp", 
			 	label: "direccionemp",
				align: "left", 
				width: 200, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			},
			{ 	name: "telf1047", 
			 	label: "telf1047",
				align: "center", 
				width: 50, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: false
			}
        ],
        model:"Ab03b47v00",
        usePlugins:[
			"feedback",
			"fluid",
			"toolbar",
			"filter"
        ],
		primaryKey: "id047",
		sortname: "numRera047",
		sortorder: "asc",
		loadOnStartUp: true,
		feedback:{
			config:{
				block: false
			}
		},
		toolbar: {
			createDefaultToolButtons: false,
			buttons: []
		}
	});
	
	$("#empresa_filter_form").rup_validate({
		feedback:$("#empresa_feedback"),
		liveCheckingErrors: false,
		rules:{
			"fechaInscDesde":{date:true, validacionFechas:true},
			"fechaInscHasta":{date:true, validacionFechas:true},
			"telf1047":{digits:true}
		}
	});	
	
	$("#empresa").on("rupTable_beforeFilter",
		function(){
			if(ab03bUtils.form.validate($("#empresa_filter_form"))){	
				return true;
			} else {
				return false;
			}
		});
	
	$("#formHttpSubmit_button_pdf").bind("click",function(e){
		if ($('#empresa_filter_form').validate().checkForm()) {
			
			document.getElementById("numRera047").value = document.getElementById("numRera047_filter_table").value;
			document.getElementById("fDesdeInscrip").value = document.getElementById("fechaInscDesde").value;
			document.getElementById("fHastaInscrip").value = document.getElementById("fechaInscHasta").value;
			document.getElementById("razonSocial047").value = document.getElementById("razonSocial047_filter_table").value;
			document.getElementById("direccionemp").value = document.getElementById("direccionemp_filter_table").value;
			document.getElementById("telf1047").value = document.getElementById("telf1047").value;
			document.getElementById("siPerteneCAVPdf").value = document.getElementById("siPerteneCAV").checked;
			document.getElementById("noPerteneCAVPdf").value = document.getElementById("noPerteneCAV").checked;
			document.getElementById("altaEstado047Pdf").value = document.getElementById("altaEstado047").checked;
			document.getElementById("bajaEstado047Pdf").value = document.getElementById("bajaEstado047").checked;
			document.getElementById("nifEmpresa047").value = document.getElementById("nifEmpresa047_filter_table").value;
			
			$('#formHttpSubmit').submit();
		}
	});
});

//Funcion limpiar
$('#empresa_filter_cleanLink').click(function(event){
	resetFiltro($("#empresa_filter_form"));
	
	//se borran los mensajes de errores que se muestran en el feedback
	$("#empresa_filter_form").validate().submitted = {};
	//se cierra el feedback
	$("#empresa_feedback").rup_feedback("close");
	
	$("#empresa").rup_table('filter'); 
	
	// se quitan las imagenes que marcan el error
	$(".rup-maint_validateIcon", $("#empresa_filter_form")).remove();

});

function relacionEmpresas(){
	// Llamada ajax para sacar el listado de empresas
	$.rup_ajax({
		url : $.rup.CTX_PATH +"ab03b47v00/listado",
		type: "POST",
		data: JSON.stringify(serializeEmpresa()),
		dataType : 'json',
		contentType : 'application/json',
		success : function(xhr, ajaxOptions) {
			//$.unblockUI();
			ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#empresa_feedback"));					
		},
		error : function(error){
			pintarFeedbackError(error.responseText, $("#empresa_feedback"));
		}/*,
		complete: function() {
			ab03bUtils.util.desBloquearInterfaz();
		}*/
	});
}

//Funcion que serializa la empresa para ser enviado
function serializeEmpresa(){
	return $("#empresa_filter_form").rup_form('formToJson');
}